"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const ByteArray_1 = require("../internal/ByteArray");
const Native = require("../../../Native");
const UuidCiphertext_1 = require("../groups/UuidCiphertext");
class CallLinkAuthCredentialPresentation extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CallLinkAuthCredentialPresentation_CheckValidContents);
    }
    verify(serverParams, callLinkParams, now = new Date()) {
        Native.CallLinkAuthCredentialPresentation_Verify(this.contents, Math.floor(now.getTime() / 1000), serverParams.contents, callLinkParams.contents);
    }
    getUserId() {
        return new UuidCiphertext_1.default(Native.CallLinkAuthCredentialPresentation_GetUserId(this.contents));
    }
}
exports.default = CallLinkAuthCredentialPresentation;
//# sourceMappingURL=CallLinkAuthCredentialPresentation.js.map